﻿<%@ Page Language="c#" CodePage="1200" autoeventwireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.EwidencjaVat" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Elementy rozliczeń VAT - wg dokumentów</title>
		<META http-equiv="Content-Type" content="text/html; charset=unicode">
		<script runat="server">

    void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
			ElemRozliczeniaVAT elem = (ElemRozliczeniaVAT)args.Row;
			VATEwidencja ewid = (VATEwidencja)elem.Naglowek.Naglowek.Ewidencja;
			Grid1.GroupLine = string.Format("{0}({5}) - {1} - {2} ({3}) {4}",ewid.NumerDokumentu,ewid.DataDokumentu,ewid.DaneKontrahenta.Nazwa,ewid.DaneKontrahenta.EuVAT,ewid.DaneKontrahenta.Adres,ewid.Numer.NumerPelny);
    }

    void ElementyRozliczenVAT_OnLoad(Object sender, EventArgs args){
      EleRozliczenVATT.Params p = (EleRozliczenVATT.Params)DataContext1.Get(typeof(EleRozliczenVATT.Params)); 
      ReportHeader1.Title = 
				String.Format(ReportHeader1.Title,p.Typ,
				p.Zakres, p.Definicja==null ? "Wszystkie" : p.Definicja.ToString(), p.Podmiot==null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty,
				p.Odliczenia, p.RodzajZakupu, p.RodzajPodmiotu, p.StatusPodmiotu);
         
   			Grid2.DataSource = new SumatorStawek((Row[])DataContext1.Get(typeof(Row[]))).Sumy;
    }
    
    public class SumatorStawek{
			Row[] rows = null;
			Hashtable sumy = new Hashtable();
			
			public SumatorStawek(Row[] rows){
				this.rows = rows;
				foreach(ElemRozliczeniaVAT elem in rows){
					Suma suma = (Suma)sumy[elem.Stawka.ToString()];
					if(suma==null){
						suma = new Suma(elem.Stawka.ToString());
						sumy.Add(elem.Stawka.ToString(),suma);						
					}
					suma.Add(elem.Netto.Value,elem.VAT.Value,elem.Brutto.Value);					
				}
				
			}
			
			public IEnumerable Sumy{
				get{
					return sumy.Values;
				}
			}
			
			public class Suma{
				readonly string stawka;
				decimal netto,vat,brutto;
				
				public Suma(string stawka){
					this.stawka = stawka;
				}
				
				public string Stawka{ get{ return stawka;} }
				public decimal Netto{ get{ return netto;} }				
				public decimal VAT{ get{ return vat;} }								
				public decimal Brutto{ get{ return brutto;} }
				
				public void Add(decimal netto,decimal vat,decimal brutto){
					this.netto += netto;
					this.vat += vat;
					this.brutto += brutto;
				}
				
			}
    }
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ElementyRozliczenVAT" method="post" onload="ElementyRozliczenVAT_OnLoad" runat="server">
			<ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"
				Landscape="True"></ea:DataContext>
			<br>
			<cc1:ReportHeader id="ReportHeader1" title="Elementy rozliczeń VAT - wg dokumentów | Typ ewidencji: {0}, Za okres: {1} | Definicja: {2}, Podmiot: {3}, Korekty: {4} | Odliczenia: {5}, Rodzaj zakupu: {6} | Rodzaj podmitu: {7}, Status podmiotu: {8}"
				runat="server"></cc1:ReportHeader>
			<br>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
				OnBeforeRow="Grid1_BeforeRow" GroupLine="NumerDokumentu - DataDokumentu - Podmiot" Sort="Naglowek.Naglowek.DataZaewidencjonowania,Naglowek.Naglowek.NumerDokumentu,Naglowek.Naglowek"
				ShowTotalSum="True">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Center" DataMember="Data" Total="Info" Caption="Data roz."></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Center" DataMember="Rodzaj"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Center" DataMember="Odliczenia"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Stawka" Caption="Stawka"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Netto.Value" Total="Sum" Caption="Netto" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="VAT.Value" Total="Sum" Caption="VAT" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Brutto.Value" Total="Sum" Caption="Brutto" Format="{0:n}"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<P><FONT face="Tahoma" size="1"><STRONG>Podsumowanie wg stawek VAT</STRONG></FONT>
				<ea:Grid id="Grid2" runat="server" WithSections="False">
					<Columns>
						<ea:GridColumn Width="59" Align="Center" DataMember="Stawka" Total="Info"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Netto" Total="Sum" Caption="Netto" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="VAT" Total="Sum" Caption="VAT" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Brutto" Total="Sum" Caption="Brutto" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:Grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="OperatorCzas"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter>
		</form>
		</P>
	</body>
</HTML>

